/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.CmdExtendedError;
import com.ibm.hsc.common.util.HexDump;
import com.ibm.hsc.common.util.HscPrintStream;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class CmdExtendedErrorList
implements ListIterator {
    private Vector m_errorList = new Vector();
    private int m_position = 0;
    private static final int NUMBER_SIZE = 2;
    private static final int ERROR_OFFSET = 4;

    public CmdExtendedErrorList() {
    }

    public CmdExtendedErrorList(byte[] byArray) {
        if (byArray != null && byArray.length >= 2) {
            int n;
            long l = 0L;
            for (n = 0; n < 2; ++n) {
                l |= (long)(byArray[n] << (1 - n) * 8);
            }
            n = 4;
            int n2 = 0;
            while ((long)n2 < l) {
                int n3 = byArray[n++] << 8 | byArray[n++];
                this.m_errorList.add(new CmdExtendedError(ByteUtilities.byteCopy(new byte[0], 0, byArray, n, n3 - 2)));
                n += n3 - 2;
                ++n2;
            }
        }
    }

    public void appendError(CmdExtendedError cmdExtendedError) {
        this.m_errorList.add(cmdExtendedError);
    }

    public void appendList(CmdExtendedErrorList cmdExtendedErrorList) {
        Object var2_2 = null;
        CmdExtendedErrorList cmdExtendedErrorList2 = cmdExtendedErrorList;
        while (cmdExtendedErrorList2.hasNext()) {
            this.m_errorList.add(cmdExtendedErrorList2.next());
        }
    }

    public byte[] getBytes() {
        int n;
        byte[] byArray = new byte[4];
        int n2 = this.getNumberOfErrors();
        for (n = 0; n < 2; ++n) {
            byArray[n] = (byte)(n2 >> (1 - n) * 8 & 0xFF);
        }
        for (n = 0; n < n2; ++n) {
            byte[] byArray2 = this.getErrorAt(n).getError();
            byArray = ByteUtilities.byteCat(byArray, byArray2);
        }
        return byArray;
    }

    public CmdExtendedError[] getErrorArray() {
        return this.m_errorList.toArray(new CmdExtendedError[0]);
    }

    public CmdExtendedError getErrorAt(int n) {
        return (CmdExtendedError)this.m_errorList.elementAt(n);
    }

    public int getNumberOfErrors() {
        return this.m_errorList.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("Extended Errors:\n");
        if (this.m_errorList == null || this.m_errorList.size() < 1) {
            stringBuffer.append("     errors = null.");
            return stringBuffer.toString();
        }
        for (int i = 0; i < this.m_errorList.size(); ++i) {
            CmdExtendedError cmdExtendedError = (CmdExtendedError)this.m_errorList.elementAt(i);
            stringBuffer.append("     ErrorCode[" + i + "] = " + Long.toHexString(cmdExtendedError.extractErrorCode()) + "\n");
            stringBuffer.append("     Correlator = " + Long.toHexString(cmdExtendedError.extractModifier()) + "\n");
            byte[] byArray = cmdExtendedError.getErrorParms();
            if (byArray.length <= 0 || !HscPrintStream.isTraceActive()) continue;
            stringBuffer.append("     Parms = " + new HexDump(byArray) + "\n");
        }
        return stringBuffer.toString();
    }

    public void add(Object object) {
        this.m_errorList.add(this.m_position++, object);
    }

    public boolean hasNext() {
        return this.m_position < this.m_errorList.size();
    }

    public boolean hasPrevious() {
        return this.m_position > 0;
    }

    public Object next() {
        if (this.m_position >= this.m_errorList.size()) {
            throw new NoSuchElementException();
        }
        return this.m_errorList.elementAt(this.m_position++);
    }

    public int nextIndex() {
        return this.m_position;
    }

    public Object previous() {
        if (this.m_position <= 0) {
            throw new NoSuchElementException();
        }
        return this.m_errorList.elementAt(this.m_position-- - 1);
    }

    public int previousIndex() {
        return this.m_position - 1;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void set(Object object) {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] stringArray) {
        int n;
        CmdExtendedErrorList cmdExtendedErrorList = new CmdExtendedErrorList();
        byte[] byArray = new byte[]{0, 0, 1, 1, 1, 1};
        CmdExtendedError cmdExtendedError = new CmdExtendedError(byArray);
        cmdExtendedErrorList.appendError(cmdExtendedError);
        byArray = new byte[]{0, 0, 1, 1, 1, 2};
        cmdExtendedError = new CmdExtendedError(byArray);
        cmdExtendedErrorList.appendError(cmdExtendedError);
        byArray = new byte[]{0, 0, 1, 1, 1, 3};
        cmdExtendedError = new CmdExtendedError(byArray);
        cmdExtendedErrorList.appendError(cmdExtendedError);
        System.out.println("Number of errors = " + cmdExtendedErrorList.getNumberOfErrors());
        byte[] byArray2 = cmdExtendedErrorList.getBytes();
        for (n = 0; n < byArray2.length; ++n) {
            System.out.println("    byte[" + n + "] = " + byArray2[n]);
        }
        while (cmdExtendedErrorList.hasNext()) {
            System.out.println("Error: ");
            byArray = ((CmdExtendedError)cmdExtendedErrorList.next()).getError();
            for (n = 0; n < byArray.length; ++n) {
                System.out.println("    byte[" + n + "] = " + byArray[n]);
            }
        }
        CmdExtendedErrorList cmdExtendedErrorList2 = new CmdExtendedErrorList();
        byArray = new byte[]{0, 0, 2, 2, 2, 1};
        cmdExtendedError = new CmdExtendedError(byArray);
        cmdExtendedErrorList2.appendError(cmdExtendedError);
        byArray = new byte[]{0, 0, 2, 2, 2, 2};
        cmdExtendedError = new CmdExtendedError(byArray);
        cmdExtendedErrorList2.appendError(cmdExtendedError);
        byArray = new byte[]{0, 0, 2, 2, 2, 3};
        cmdExtendedError = new CmdExtendedError(byArray);
        cmdExtendedError.setModifier(255);
        cmdExtendedErrorList2.appendError(cmdExtendedError);
        cmdExtendedErrorList.appendList(cmdExtendedErrorList2);
        System.out.println("Number of errors = " + cmdExtendedErrorList.getNumberOfErrors());
        byArray2 = cmdExtendedErrorList.getBytes();
        for (int i = 0; i < byArray2.length; ++i) {
            System.out.println("    byte[" + i + "] = " + byArray2[i]);
        }
    }
}

